#ifdef _USE_NEW_HEADER_
/**************************************************************************************
  @licensetext
 **************************************************************************************

   Last Modification:
    @version $Id: Od2_Public.h 6856 2010-03-24 12:12:14Z Sven $

   Description:


   Changes:

     Date        Author        Description
     ----------------------------------------------------------------------------------
     2010-03-24  SB            Created
**************************************************************************************/
#else
/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: Od2_Public.h $
   Last Modification:
    $Author: Sven $
    $Modtime: 20.06.08 12:45 $
    $Revision: 27 $

   Targets:
    rcX          : yes

   Description:

    Object Dictionary public API

   Changes:

     Version    Date        Author   Description
     ----------------------------------------------------------------------------------
     27        20.06.2008 sb
        added disable createobject flag
        added object created callback
        added subobject created callback
        added general object written callback
        added default value storage for num of subindex

     26        11.06.2008  sb
        added locking functions
        added work buffer handling

     25        10.06.2008 sb
        added subobject info

     24        27.09.2007 sb
        refurbished common data type naming

     23        07.09.2007 sb
        added support for reading/writing objects not defined in the object dictionary

     22        03.07.2007  sb
        added support for datatype creation and deletion

     21        23.03.2007  sb
        updated source header

     20        20.03.2007  sb
        Code cleanup

      1        29.07.2005  SB       1.000
        Updated header to SourceSafe compatibility
        Updated callback API to allow implementing
          packet notify functions

**************************************************************************************/
#endif

#ifndef __OD2_PUBLIC_H
#define __OD2_PUBLIC_H

#include "od2_error.h"

#define OD2_SUBOBJ_ACCESS_ALL (0xffff)

#define OD2_OBJ_ACCESS_RXPDOMAP (0x0001)
#define OD2_OBJ_ACCESS_TXPDOMAP (0x0002)
#define OD2_OBJ_ACCESS_CONFIG (0x0004)
#define OD2_OBJ_ACCESS_INDEXED (0x0008)
#define OD2_OBJ_ACCESS_PDOMAP (0x0003)
#define OD2_OBJ_ACCESS_BACKUP (0x0010)

#define OD2_DIR_NOT_DEF  0x0
#define OD2_DIR_INPUT    0x1    //input of the device
#define OD2_DIR_OUTPUT   0x2    //output of the device
#define OD2_DIR_ALL      0x3

#define OD2_SENDER_NETWORK ((TLR_HANDLE)1)

typedef void* OD2_SENDER_HANDLE;
typedef void* OD2_OBJDICT_HANDLE;
typedef int OD2_BOOLEAN;
typedef UINT32 OD2_RESULT;

enum
{
  /* subobject is not allocated yet */
  OD2_ALLOC_NONE,
  /* subobject data storage is allocated by the application */
  OD2_ALLOC_APP,
  /* subobject data storage is allocated by the object dictionary */
  OD2_ALLOC_OBJMGMT,
  /* subobject data storage pointer are relative to an external base pointer */
  OD2_ALLOC_RELATIVE
};

typedef UINT8 OD2_ALLOC_TYPE;

typedef struct OD2_SUBOBJECT_Ttag
{
  /* direction of the subobject */
  UINT16                      usDirection;
  /* subobject access flags */
  UINT16                      usAccess;
  /* datatype of the subobject */
  UINT16                      usDataType;
  /* field length (in data type units) of the subobject if variable length */
  UINT16                      usFieldLen;
  /* allocation type of subobject */
  OD2_ALLOC_TYPE              eAllocType;
  /* name of the subobject */
  char*                       pszName;
  /* default value of the subobject */
  void*                       pvDefault;
  /* minimum value of the subobject */
  void*                       pvMin;
  /* maximum value of the subobject */
  void*                       pvMax;
  /* data value of the subobject */
  void*                       pvData;
  /* work buffer */
  void*                       pvWorkBuffer;
} OD2_SUBOBJECT_T;

typedef struct OD2_DATATYPE_ENTRY_Ttag {
  /* bit size of the data type */
  UINT                        uBitSize;
  /* has the object variable size */
  OD2_BOOLEAN                 fVariableLength;
} OD2_DATATYPE_ENTRY_T;

typedef struct OD2_DATATYPE_TABLE_Ttag {
  /* pointer to data type table */
  OD2_DATATYPE_ENTRY_T*       patEntryTable;
  /* number of data type entries */
  UINT                        uNumDataTypes;
} OD2_DATATYPE_TABLE_T;


typedef OD2_RESULT (* OD2_FN_ACCESS_NOTIFY_T)(
                                                 OD2_SENDER_HANDLE  hSender,
                                                 UINT16             usIndex,
                                                 UINT8              bSubIdx,
                                                 OD2_SUBOBJECT_T*   ptSubObject,
                                                 void*              pvNewData,
                                                 void*              pvUserData,
                                                 void*              pvRsc);

typedef void (* OD2_FN_OBJECT_CREATED_T)(
                                                 UINT16             usIndex,
                                                 void*              pvUserData,
                                                 void*              pvRsc);

typedef void (* OD2_FN_SUBOBJECT_CREATED_T)(     UINT16             usIndex,
                                                 UINT8              bSubIdx,
                                                 void*              pvUserData,
                                                 void*              pvRsc);

typedef void (* OD2_FN_GETLIST_T)(UINT16 usIndex, void* pvUserData);


typedef OD2_RESULT (* OD2_FN_UNDEF_ACCESS_NOTIFY_T)(
                                                 OD2_SENDER_HANDLE  hSender,
                                                 UINT16             usIndex,
                                                 UINT8              bSubIdx,
                                                 void*              pvNewData,
                                                 UINT16             usDataSizeInBytes,
                                                 void*              pvUserData,
                                                 void*              pvRsc);

typedef OD2_RESULT (* OD2_FN_GET_DATATYPE_DEF_FOR_READ_T)(
                                                 UINT16             usIndex,
                                                 UINT8              bSubIdx,
                                                 UINT16*            pusDataType,
                                                 UINT16*            pusFieldLen,
                                                 void*              pvUserData,
                                                 void*              pvRsc);

typedef struct OD2_CALLBACK_DATA_Ttag
{
  /* magic value to check for valid callback data */
  UINT32                  uMagic;
  /* callback function */
  OD2_FN_ACCESS_NOTIFY_T  fnCallback;
  /* subobject pointer */
  OD2_SUBOBJECT_T*        ptSubObject;
  /* userdata pointer */
  void*                   pvUserData;
  /* resources pointer */
  void*                   pvRsc;
} OD2_CALLBACK_DATA_T;

/************************************************************************************************/

OD2_RESULT Od2_Init(void* pvPer, UINT ulPer);

/************************************************************************************************/

OD2_RESULT Od2_CreateObjDict(
                             char*                  paszName,
                             UINT                   uInst,
                             UINT                   uTasksPerObjDict,
                             UINT16                 usDataTypeUnsigned8,
                             OD2_DATATYPE_TABLE_T*  ptDataTypes,
                             OD2_OBJDICT_HANDLE*    phObjDict);

/************************************************************************************************/

OD2_RESULT Od2_IdentifyObjDict(
                             char*                  paszName,
                             UINT                   uInst,
                             OD2_OBJDICT_HANDLE*    phObjDict);


/************************************************************************************************/

void Od2_EnableWorkBufferAllocation(
                            OD2_OBJDICT_HANDLE                  hObjDict);

void Od2_DisableObjectDeletion(
                            OD2_OBJDICT_HANDLE                  hObjDict);

void Od2_DisableObjectCreation(
                            OD2_OBJDICT_HANDLE                  hObjDict);

/************************************************************************************************/

OD2_RESULT Od2_SetReadPrepareUndefinedObjectCallback(
                            OD2_OBJDICT_HANDLE                  hObjDict,
                            OD2_FN_GET_DATATYPE_DEF_FOR_READ_T  pfnCallback,
                            void*                               pvUserData,
                            void*                               pvRsc);

OD2_RESULT Od2_SetReadUndefinedObjectCallback(
                            OD2_OBJDICT_HANDLE                  hObjDict,
                            OD2_FN_UNDEF_ACCESS_NOTIFY_T        pfnCallback,
                            void*                               pvUserData,
                            void*                               pvRsc);

/************************************************************************************************/

OD2_RESULT Od2_SetWriteUndefinedObjectCallback(
                            OD2_OBJDICT_HANDLE                  hObjDict,
                            OD2_FN_UNDEF_ACCESS_NOTIFY_T        pfnCallback,
                            void*                               pvUserData,
                            void*                               pvRsc);

/************************************************************************************************/

OD2_RESULT Od2_SetSubIdx0AccessMask(OD2_OBJDICT_HANDLE          hObjDict,
                                    UINT16                      usReadOnlyAccessMask,
                                    UINT16                      usReadWriteAccessMask);

/************************************************************************************************/

OD2_RESULT Od2_DeleteObjDict(
                             OD2_OBJDICT_HANDLE                 hObjDict);

/************************************************************************************************/

OD2_RESULT Od2_CreateDatatype(
                              OD2_OBJDICT_HANDLE                hObjDict,
                              UINT16                            usDatatype,
                              UINT                              uBitSize,
                              OD2_BOOLEAN                       fVariableLength);

/************************************************************************************************/

OD2_RESULT Od2_DeleteDatatype(
                              OD2_OBJDICT_HANDLE                hObjDict,
                              UINT16                            usDatatype);

/************************************************************************************************/

OD2_RESULT Od2_SetCurrentAccessMask(
                                    OD2_OBJDICT_HANDLE          hObjDict,
                                    UINT16                      usReadAccessMask,
                                    UINT16                      usWriteAccessMask);

/************************************************************************************************/

OD2_RESULT Od2_SetObjectSubIdx0Access(
                                      OD2_OBJDICT_HANDLE        hObjDict,
                                      UINT16                    usIndex,
                                      UINT16                    usReadOnlyAccessMask,
                                      UINT16                    usReadWriteAccessMask);

/************************************************************************************************/

OD2_RESULT Od2_FastReadObject(OD2_OBJDICT_HANDLE                hObjDict,
                              OD2_SENDER_HANDLE                 hSender,
                              UINT16                            usIndex,
                              void*                             pvBuffer);

/************************************************************************************************/

OD2_RESULT Od2_FastReadSubobject(OD2_OBJDICT_HANDLE             hObjDict,
                                 OD2_SENDER_HANDLE              hSender,
                                 UINT16                         usIndex,
                                 UINT8                          bSubIdx,
                                 void*                          pvBuffer);

/************************************************************************************************/

OD2_RESULT Od2_FastWriteObject(OD2_OBJDICT_HANDLE               hObjDict,
                               OD2_SENDER_HANDLE                hSender,
                               UINT16                           usIndex,
                               void*                            pvBuffer);

/************************************************************************************************/

OD2_RESULT Od2_FastWriteSubobject(OD2_OBJDICT_HANDLE            hObjDict,
                                  OD2_SENDER_HANDLE             hSender,
                                  UINT16                        usIndex,
                                  UINT8                         bSubIdx,
                                  void*                         pvBuffer);

/************************************************************************************************/

OD2_RESULT Od2_WriteObject(OD2_OBJDICT_HANDLE                   hObjDict,
                           OD2_BOOLEAN                          fWriteWholeObject,
                           OD2_SENDER_HANDLE                    hSender,
                           UINT16                               usIndex,
                           UINT8                                bSubIdx,
                           UINT16                               usBuffLenInByte,
                           UINT16*                              pusNumOfSubobjWrit,
                           UINT16*                              pusDatatype,
                           void*                                pvBuffer);

/************************************************************************************************/

OD2_RESULT Od2_ReadObject(OD2_OBJDICT_HANDLE                    hObjDict,
                          OD2_BOOLEAN                           fReadWholeObject,
                          OD2_SENDER_HANDLE                     hSender,
                          UINT16                                usIndex,
                          UINT8                                 bSubIdx,
                          UINT16                                usBuffLenInByte,
                          UINT16*                               pusNumOfSubobjRead,
                          UINT16*                               pusDatatype,
                          void*                                 pvBuffer);

/************************************************************************************************/

OD2_RESULT Od2_DeleteObject(OD2_OBJDICT_HANDLE                  hObjDict,
                            OD2_BOOLEAN                         fDeleteWholeObject,
                            OD2_SENDER_HANDLE                   hSender,
                            UINT16                              usIndex,
                            UINT8                               bSubIdx);

/************************************************************************************************/

OD2_RESULT Od2_CreateObject(OD2_OBJDICT_HANDLE                  hObjDict,
                            OD2_BOOLEAN                         fCreateWholeObject,
                            OD2_ALLOC_TYPE                      fAllocMode,
                            OD2_SENDER_HANDLE                   hSender,
                            UINT16                              usIndex,
                            UINT8                               bNumOfSubIdx,
                            UINT8                               bMaxSubIdx,
                            UINT8                               bSubIdx,
                            UINT16                              usDirection,
                            UINT16                              usObjAccess,
                            UINT8                               bObjectCode,
                            UINT16                              usSubObjAccess,
                            UINT16                              usDatatype,
                            UINT16                              usFieldLen,
                            void*                               pvDefaultVal,
                            void*                               pvMinVal,
                            void*                               pvMaxVal,
                            void*                               pvSubObject,
                            OD2_FN_ACCESS_NOTIFY_T              fnReadAccess,
                            void*                               pvReadUserData,
                            void*                               pvReadRsc,
                            OD2_FN_ACCESS_NOTIFY_T              fnWriteAccess,
                            void*                               pvWriteUserData,
                            void*                               pvWriteRsc);

/************************************************************************************************/

OD2_RESULT Od2_SetupObjectCallback(OD2_OBJDICT_HANDLE           hObjDict,
                                   OD2_SENDER_HANDLE            hSender,
                                   UINT16                       usIndex,
                                   OD2_FN_ACCESS_NOTIFY_T       fnReadAccess,
                                   void*                        pvReadUserData,
                                   void*                        pvReadRsc,
                                   OD2_FN_ACCESS_NOTIFY_T       fnWriteAccess,
                                   void*                        pvWriteUserData,
                                   void*                        pvWriteRsc);

/************************************************************************************************/

OD2_RESULT Od2_SetupCommonObjectCallback(
                                   OD2_OBJDICT_HANDLE           hObjDict,
                                   OD2_FN_OBJECT_CREATED_T      pfnObjectCreated,
                                   void*                        pvObjectCreatedUserData,
                                   void*                        pvObjectCreatedRsc,
                                   OD2_FN_SUBOBJECT_CREATED_T   pfnSubobjectCreated,
                                   void*                        pvSubobjectCreatedUserData,
                                   void*                        pvSubobjectCreatedRsc,
                                   OD2_FN_ACCESS_NOTIFY_T       pfnWritePrepare,
                                   void*                        pvWritePrepareUserData,
                                   void*                        pvWritePrepareRsc,
                                   OD2_FN_ACCESS_NOTIFY_T       pfnWriteComplete,
                                   void*                        pvWriteCompleteUserData,
                                   void*                        pvWriteCompleteRsc);

/************************************************************************************************/

/* helper functions for simpler access to partial object creation functionality of Od2_CreateObject */
OD2_RESULT Od2_DefineObject(
                            OD2_OBJDICT_HANDLE                  hObjDict,
                            OD2_SENDER_HANDLE                   hSender,
                            UINT16                              usIndex,
                            UINT8                               bNumOfSubIdx,
                            UINT8                               bMaxSubIdx,
                            UINT16                              usObjAccess,
                            UINT8                               bObjectCode,
                            UINT16                              usDataType,
                            OD2_FN_ACCESS_NOTIFY_T              fnReadAccess,
                            void*                               pvReadUserData,
                            void*                               pvReadRsc,
                            OD2_FN_ACCESS_NOTIFY_T              fnWriteAccess,
                            void*                               pvWriteUserData,
                            void*                               pvWriteRsc);

OD2_RESULT Od2_CreateSubObject(
                               OD2_OBJDICT_HANDLE               hObjDict,
                               OD2_ALLOC_TYPE                   eAllocMode,
                               OD2_SENDER_HANDLE                hSender,
                               UINT16                           usIndex,
                               UINT8                            bSubIdx,
                               UINT16                           usDirection,
                               UINT16                           usSubObjAccess,
                               UINT16                           usDatatype,
                               UINT16                           usFieldLen,
                               void*                            pvDefaultVal,
                               void*                            pvMinVal,
                               void*                            pvMaxVal,
                               void*                            pvSubObject);

/************************************************************************************************/

/* Retrieve the list of objects put into the object dictionary */
OD2_RESULT Od2_GetObjectList(
                             OD2_OBJDICT_HANDLE                 hObjDict,
                             UINT16                             usAccessMask,
                             UINT16                             usAccessBitsSet,
                             OD2_FN_GETLIST_T                   fnCallback,
                             void*                              pvUserData);

/************************************************************************************************/

OD2_RESULT Od2_GetObjectDescription(
                                    OD2_OBJDICT_HANDLE          hObjDict,
                                    UINT16                      usIndex,
                                    UINT8*                      pbObjectType,
                                    UINT16*                     pusObjAccess,
                                    UINT8*                      pbNumSubIdx,
                                    UINT8*                      pbMaxSubIdx,
                                    UINT16*                     pusDatatype,
                                    const char**                ppszName);

/************************************************************************************************/

OD2_RESULT Od2_GetAllocType(
                            OD2_OBJDICT_HANDLE                  hObjDict,
                            UINT16                              usIndex,
                            UINT8                               bSubIdx,
                            OD2_ALLOC_TYPE*                     peAllocType);

/************************************************************************************************/

#define OD2_INVALID_BIT_LENGTH (0xffffffff)
UINT32 Od2_GetBitLength(
                            OD2_OBJDICT_HANDLE                  hObjDict,
                            UINT16                              usDataType,
                            UINT16                              usFieldLen);

/************************************************************************************************/

OD2_RESULT Od2_GetObjectAccessTypes(
                                    OD2_OBJDICT_HANDLE          hObjDict,
                                    UINT16                      usIndex,
                                    UINT16*                     pusAccess);

/************************************************************************************************/

OD2_RESULT Od2_GetSubObjectAccessTypes(
                                       OD2_OBJDICT_HANDLE       hObjDict,
                                       UINT16                   usIndex,
                                       UINT8                    bSubIdx,
                                       UINT16*                  pusAccess);

/************************************************************************************************/

OD2_RESULT Od2_GetNumberOfSubObj(
                                 OD2_OBJDICT_HANDLE             hObjDict,
                                 UINT16                         usIndex,
                                 UINT8*                         pbNumOfSubObj);

/************************************************************************************************/

OD2_RESULT Od2_ReadNotifySubObject(
                                   OD2_OBJDICT_HANDLE           hObjDict,
                                   OD2_SENDER_HANDLE            hSender,
                                   UINT16                       usIndex,
                                   UINT8                        bSubIdx);

/************************************************************************************************/

OD2_RESULT Od2_WriteNotifySubObject(
                                    OD2_OBJDICT_HANDLE          hObjDict,
                                    OD2_SENDER_HANDLE           hSender,
                                    UINT16                      usIndex,
                                    UINT8                       bSubIdx);

/************************************************************************************************/

/* Data locking function for fast mapping access */
OD2_RESULT Od2_LockSubObjectData(
                                 OD2_OBJDICT_HANDLE             hObjDict,
                                 UINT16                         usIndex,
                                 UINT8                          bSubIdx,
                                 UINT16*                        pusDirection,
                                 UINT16*                        pusDatatype,
                                 UINT16*                        pusFieldLen,
                                 void**                         ppvData);

OD2_RESULT Od2_UnlockSubObjectData(
                               OD2_OBJDICT_HANDLE               hObjDict,
                               UINT16                           usIndex,
                               UINT8                            bSubIdx);


/************************************************************************************************/

/* Data locking function for fast mapping access */
OD2_RESULT Od2_LockSubObjectInfo(
                                 OD2_OBJDICT_HANDLE             hObjDict,
                                 UINT16                         usIndex,
                                 UINT8                          bSubIdx,
                                 const OD2_SUBOBJECT_T**        pptSubObject);

OD2_RESULT Od2_UnlockSubObjectInfo(
                               OD2_OBJDICT_HANDLE               hObjDict,
                               UINT16                           usIndex,
                               UINT8                            bSubIdx);


/************************************************************************************************/

OD2_RESULT Od2_LockSubObjectCallback(
                                    OD2_OBJDICT_HANDLE          hObjDict,
                                    UINT16                      usIndex,
                                    UINT8                       bSubIdx,
                                    OD2_CALLBACK_DATA_T*        ptReadCallbackData,
                                    OD2_CALLBACK_DATA_T*        ptWriteCallbackData);

OD2_RESULT Od2_UnlockSubObjectCallback(
                                    OD2_OBJDICT_HANDLE          hObjDict,
                                    UINT16                      usIndex,
                                    UINT8                       bSubIdx);

/************************************************************************************************/

/************************************************************************************************/

#define Od2_ValidCallbackData(ptCallbackData) \
      (NULL != (ptCallbackData)->fnCallback && 0xc8ba11ca==(ptCallbackData)->uMagic)
#define Od2_ExecCallbackData(ptCallbackData, hSender, usIndex, bSubIdx, pvData) \
                 (ptCallbackData)->fnCallback( \
                                              hSender, \
                                              usIndex, \
                                              bSubIdx, \
                                              (ptCallbackData)->ptSubObject, \
                                              pvData, \
                                              (ptCallbackData)->pvUserData, \
                                              (ptCallbackData)->pvRsc)

/************************************************************************************************/

/* Non-locking version of LockSubObjectData , the value returned by this function should not be used for prolonged duration */
OD2_RESULT Od2_UnsafeSubObjectData(
                                  OD2_OBJDICT_HANDLE            hObjDict,
                                  UINT16                        usIndex,
                                  UINT8                         bSubIdx,
                                  UINT16*                       pusDirection,
                                  UINT16*                       pusDatatype,
                                  UINT16*                       pusFieldLen,
                                  void**                        ppvData);

OD2_RESULT Od2_GetSubObjectWorkData(
                    TLR_HANDLE hObjDict,
                    TLR_UINT16 usIndex,
                    TLR_UINT8 bSubIdx,
                    TLR_UINT16* pusDatatype,
                    TLR_UINT16* pusFieldLen,
                    TLR_VOID** ppvWorkBuffer);

/************************************************************************************************/

OD2_RESULT Od2_SetSubIdx0Value(
                                  OD2_OBJDICT_HANDLE            hObjDict,
                                  UINT16                        usIndex,
                                  UINT8                         bNumSubIdx);

OD2_RESULT Od2_GetSubIdx0DefaultValue(
                                  OD2_OBJDICT_HANDLE            hObjDict,
                                  UINT16                        usIndex,
                                  UINT8*                        pbNumSubIdx);

/************************************************************************************************/

OD2_RESULT Od2_SetObjectName(
                            OD2_OBJDICT_HANDLE                  hObjDict,
                            UINT16                              usIndex,
                            char*                               pszName);

OD2_RESULT Od2_GetObjectName(
                            OD2_OBJDICT_HANDLE                  hObjDict,
                            UINT16                              usIndex,
                            char**                              ppszName);

/************************************************************************************************/

OD2_RESULT Od2_SetSubobjectName(
                                OD2_OBJDICT_HANDLE              hObjDict,
                                UINT16                          usIndex,
                                UINT8                           bSubIdx,
                                char*                           pszName);

OD2_RESULT Od2_GetSubobjectName(
                                OD2_OBJDICT_HANDLE              hObjDict,
                                UINT16                          usIndex,
                                UINT8                           bSubIdx,
                                const char**                    ppszName);


#define OD2_OBJCODE_DOMAIN (0x02)
#define OD2_OBJCODE_DEFTYPE (0x05)
#define OD2_OBJCODE_DEFSTRUCT (0x06)
#define OD2_OBJCODE_VAR (0x07)
#define OD2_OBJCODE_ARRAY (0x08)
#define OD2_OBJCODE_RECORD (0x09)

#ifndef __OD2_INCLUDES__
TLR_RESULT Od2_ReadLock(OD2_OBJDICT_HANDLE hObjDict);
TLR_RESULT Od2_WriteLock(OD2_OBJDICT_HANDLE hObjDict);
TLR_RESULT Od2_Unlock(OD2_OBJDICT_HANDLE hObjDict);
#endif

#endif

